<?php

  include "../application.php";
  include "nusoap.php";

	$enable_soap_service = 0;
  $access_key = "your_secret_key_here";

  $no_key_msg = "Invalid Access Key";

  $theme_path = $theme_path . $active_theme . "/";
  include $theme_path . "msg.php";

	if ($enable_soap_service) {
  	$s = new soap_server;
  	$s->register('AddNewUser');
  	$s->register('SetPassword');
  	$s->register('GetUrl');
  	$s->register('GetPath');
  	$s->register('TestAuth');
  	$s->register('AddNewLink');
  	$s->service($HTTP_RAW_POST_DATA);
	}

  //-------------
  // add new user
  //-------------

  function AddNewUser($akey, $username, $password, $email){
    global $access_key, $no_key_msg, $msg, $dbConn;

    if (empty($username))
      $error_msg = $msg["10071"];
    elseif (strlen($username) < 3)
      $error_msg = $msg["10072"];
    elseif (empty($password))
      $error_msg = $msg["10073"];
    elseif (empty($email))
      $error_msg = $msg["10076"];
    elseif (!IsEmailAddress($email))
      $error_msg = $msg["10077"];
    elseif (!IsAlphanumeric($username))
      $error_msg = $msg["10080"];
    elseif ($akey!=$access_key)
      $error_msg = $no_key_msg;

    if (empty($error_msg)) {

      // add new user
	    $users_obj                         = new clsUsers;
  	  $users_obj->table_name             = "idx_users";
    	$users_obj->enable_user_validation = 0;
      $register                          = $users_obj->Register($username, $email, $password);
	
			if ($register == '1') {
      	$fault = new soap_fault('Client','',$msg["10078"]);
        return $fault->serialize();
      }
      else {
        // create My Favorites
        $query  = "insert into idx_favorites (username,date,title)
                   values ('$username',now(),'My Favorites')";
        $result = $dbConn->Execute($query);
      }
    }
    else {
    	$fault = new soap_fault('Client','',$error_msg);
      return $fault->serialize();
    }		
    
	  return 0;
  }


  //------------
  // SetPassword
  //------------

  function SetPassword($akey, $username, $new_password){
    global $access_key, $no_key_msg, $msg, $dbConn;

    if (empty($username))
      $error_msg = $msg["10071"];
    elseif (strlen($username) < 3)
      $error_msg = $msg["10072"];
    elseif (empty($new_password))
      $error_msg = $msg["10073"];
    elseif ($akey!=$access_key)
      $error_msg = $no_key_msg;

    if (empty($error_msg)) {
	    $users_obj             = new clsUsers;
  	  $users_obj->table_name = "idx_users";
      $users_obj->SetPassword($username, $new_password);
		}
    else {
    	$fault = new soap_fault('Client','',$error_msg);
      return $fault->serialize();
    }		

		return 0;
	}


  //-------
  // GetUrl
  //-------

  function GetUrl($akey){
    global $access_key, $no_key_msg, $site_url;

    if ($akey!=$access_key)
      $error_msg = $no_key_msg;

    if (!empty($error_msg)) {
    	$fault = new soap_fault('Client','',$error_msg);
      return $fault->serialize();
    }		

		return $site_url;
	}


  //--------
  // GetPath
  //--------

  function GetPath($akey){
    global $access_key, $no_key_msg, $base_path;

    if ($akey!=$access_key)
      $error_msg = $no_key_msg;

    if (!empty($error_msg)) {
    	$fault = new soap_fault('Client','',$error_msg);
      return $fault->serialize();
    }		

		return $base_path;
	}
	
	
  //---------
  // TestAuth
  //---------

  function TestAuth($akey, $username, $password){
    global $access_key, $no_key_msg, $msg, $dbConn;

    if (empty($username))
      $error_msg = $msg["10071"];
    elseif (strlen($username) < 3)
      $error_msg = $msg["10072"];
    elseif (empty($password))
      $error_msg = $msg["10073"];
    elseif ($akey!=$access_key)
      $error_msg = $no_key_msg;

    if (empty($error_msg)) {
	    $users_obj             = new clsUsers;
  	  $users_obj->table_name = "idx_users";
      $login                 = $users_obj->TestAuthentication($username, $password);
		}
    else {
    	$fault = new soap_fault('Client','',$error_msg);
      return $fault->serialize();
    }		

		return $login;
	}


  //-----------
  // AddNewLink
  //-----------

  function AddNewLink($akey, $link_data){
    global $access_key, $no_key_msg, $dbConn;

    if ($akey!=$access_key)
      $error_msg = $no_key_msg;
			
		if ($link_data['category_id'] == '')  {
			$error_msg = "Link has no category";
		}

		if ($link_data['title'] == '')  {
			$error_msg = $msg['10101'];
		}

    if (!empty($error_msg)) {print $error_msg;
    	$fault = new soap_fault('Client','',$error_msg);
      return $fault->serialize();
    }		

		// default value
		
		if ($link_data['hits'] == '')  {
			$link_data['hits'] = 0;
		}		
		
		if ($link_data['votes'] == '')  {
			$link_data['votes'] = 0;
		}		

		if ($link_data['rating'] == '')  {
			$link_data['rating'] = 0;
		}		

		if ($link_data['new'] == '')  {
			$link_data['new'] = 0;
		}		

		if ($link_data['hot'] == '')  {
			$link_data['hot'] = 0;
		}		

		if ($link_data['top_rated'] == '')  {
			$link_data['top_rated'] = 0;
		}		

		if ($link_data['pick'] == '')  {
			$link_data['pick'] = 0;
		}		

		if ($link_data['updated'] == '')  {
			$link_data['updated'] = 0;
		}		

		if ($link_data['password'] == '')  {
			$link_data['password'] = 0;
		}		

		if ($link_data['suspended'] == '')  {
			$link_data['suspended'] = 0;
		}				

		$values_arr = array_values($link_data);
		foreach($values_arr as $k => $v) {
			$values_arr2[] = addslashes($v);
		}

		$fields = implode(', ', array_keys($link_data));
		$values = implode("\",\"", $values_arr2);
		$values = "\"$values\"";
		
		$query  = "insert into idx_link ($fields, date)
               values ($values, now())";
    $result = $dbConn->Execute($query);

		return 0;
	}


?>